import pandas as pd
#from sklearn.decomposition import PCA
import torch
from torch import nn
from torch import optim
import numpy as np
from matplotlib import pyplot as plt
import matplotlib.ticker as mticker
from datetime import datetime as dt
from matplotlib import dates as mdates
import random

from model import Net1_dp, Net2_dp, SIS

filename = 'E:/material/timeseries/nonlineartime/data/jlndata/macro.txt'
micro = pd.read_csv(filename, sep='\t')
data = pd.DataFrame.to_numpy(micro)


hid_dim = 100

np.random.seed(0)
torch.manual_seed(0)
ls_mse_neural1 = []
ls_pred_new_neural1 = []
ls_mse_neural2 = []
ls_pred_new_neural2 = []
ls_mse_linear = []
ls_pred_new_linear = []
ls_rep = []

l1_lambda = 0.1
lr = 1e-03
dropout = 0.2
percent = 0.1 # percent :=  gamma %
y_lag = (1200*np.log(data[1:624,116]/data[0:623,116])).reshape(-1,1)
for i in np.arange(52,170,1):
    #print(i)
    data_temp = data[i:(i+453),:]
    #get obervations: x_design and repsonse: y_temp
    y_temp = (1200*np.log(data[(i+1):(i+454),116]/data[(i):(i+453),116])).reshape(-1,1)
    x_temp_lag0 = np.delete(data[(i):(i+453),:], [0,1,116], 1) 
    x_temp_lag1 = np.delete(data[(i-1):(i+452),:], [0,1,116], 1) 
    x_temp_lag2 = np.delete(data[(i-2):(i+451),:], [0,1,116], 1) 
    x_temp_lag3 = np.delete(data[(i-3):(i+450),:], [0,1,116], 1) 
    y_temp_lag = np.concatenate((y_lag[(i-1):(i+452),:], y_lag[(i-2):(i+451),:],y_lag[(i-3):(i+450),:],y_lag[(i-4):(i+449),:]), axis = 1)  
    #x_temp_pca = x_pca[(i-52):(i+401),:]
    x_design = np.concatenate((y_temp_lag,x_temp_lag0,x_temp_lag1,x_temp_lag2,x_temp_lag3),axis=1)
    if percent == 0.:
        select = np.arange(0,4,1)
    else:
        select = SIS(x_design[:,4:], y_temp, percent) + 4
        select = np.append(np.arange(0,4,1),select)
    x_design = x_design[:,np.r_[select]]
    x_design_tensor = torch.tensor(x_design, dtype = torch.float32)
    y_temp = torch.tensor(y_temp, dtype = torch.float32)
    p_dim = x_design.shape[1]    
    
    #get new observation for forecasting x_new
    x_new_lag0 = np.delete(data[i+453,:],[0,1,116])
    x_new_lag1 = np.delete(data[i+452,:],[0,1,116])
    x_new_lag2 = np.delete(data[i+451,:],[0,1,116])   
    x_new_lag3 = np.delete(data[i+450,:],[0,1,116])
    y_new_lag = np.concatenate((y_lag[i+452,:], y_lag[i+451,:],y_lag[i+450,:],y_lag[i+449,:]))
    #x_new_pca = x_pca[i+401,:]
    x_new = np.concatenate((y_new_lag,x_new_lag0,x_new_lag1,x_new_lag2,x_new_lag3))
    x_new = x_new[np.r_[select]]
    x_new = torch.tensor(x_new, dtype = torch.float32).reshape(1,-1)
    #list of true response
    ls_rep.append((1200*np.log(data[(i+454),116]/data[(i+453),116])))

    
    #--------------------------------------------------------------------------------
    #neural network1(1 hidden layers) -- train and forecast
    model_ts = Net1_dp(p_dim = p_dim, hid_dim = hid_dim, dropout = dropout) 
    criteon = nn.MSELoss() 
    optimizer = optim.Adam(model_ts.parameters(), lr)

  
    loss_valid = 999999
    
    # test:0 - 300  validation : 300 - 453
    for epoch in range(20000):
        model_ts.training = True
        #model_ts.training = False
        output_ts = model_ts(x_design_tensor[0:300,:])
        l1_reg = torch.tensor(0.)
        for it, param in enumerate(model_ts.parameters()):
            if it % 2 == 0:
                l1_reg += torch.linalg.norm(param, 1)
        loss_ts_train = criteon(output_ts, y_temp[0:300,]) + l1_reg*l1_lambda
        #backprop
        optimizer.zero_grad()   
        loss_ts_train.backward()
        optimizer.step()
        
        if (epoch+1) % 200 == 0:
            model_ts.training = False
            valid_ts = model_ts(x_design_tensor[300:453,:])
            loss_valid_temp = criteon(valid_ts, y_temp[300:453,]).item()
            #print(loss_valid_temp) 
            if loss_valid_temp > loss_valid:
                break
            else :
                loss_valid = loss_valid_temp
  
    #print(epoch)
    model_ts.training = False
    pred_new = model_ts(x_new)[0,0].detach().numpy() - 0.0
    
    ls_pred_new_neural1.append(pred_new)
    ls_mse_neural1.append((1200*np.log(data[(i+454),116]/data[(i+453),116])-pred_new)**2)

    #------------------------------------------------------------------------------
    #neural network2(4 hidden layers) -- train and forecast
    model_ts = Net2_dp(p_dim = p_dim, hid_dim = hid_dim, dropout = dropout) 
    criteon = nn.MSELoss() 
    optimizer = optim.Adam(model_ts.parameters(), lr)

  
    loss_valid = 999999
    
    # test:0 - 300  validation : 300 - 453
    for epoch in range(20000):
        model_ts.training = True
        output_ts = model_ts(x_design_tensor[0:300,:])
        l1_reg = torch.tensor(0.)
        for it, param in enumerate(model_ts.parameters()):
            if it % 2 == 0:
                l1_reg += torch.linalg.norm(param, 1)
        loss_ts_train = criteon(output_ts, y_temp[0:300,]) + l1_reg*l1_lambda
        #backprop
        optimizer.zero_grad()   
        loss_ts_train.backward()
        optimizer.step()
        
        if (epoch+1) % 200 == 0:
            model_ts.training = False
            valid_ts = model_ts(x_design_tensor[300:453,:])
            loss_valid_temp = criteon(valid_ts, y_temp[300:453,]).item()
            #print(loss_valid_temp) 
            if loss_valid_temp > loss_valid:
                break
            else :
                loss_valid = loss_valid_temp
  
    #print(epoch)
    model_ts.training = False
    pred_new = model_ts(x_new)[0,0].detach().numpy() - 0.0
    
    ls_pred_new_neural2.append(pred_new)
    ls_mse_neural2.append((1200*np.log(data[(i+454),116]/data[(i+453),116])-pred_new)**2)

    #-------------------------------------------------------------------------------
    #linear regression --- train and forecast    
    xx = torch.mm(x_design_tensor.T,x_design_tensor)
    xx_inv = torch.linalg.inv(xx)
    xy = torch.mv(x_design_tensor.T,y_temp.reshape(-1))
    w_es = torch.mv(xx_inv,xy)
    y_es = torch.mv(x_design_tensor, w_es)
    y_pred = torch.mv(x_new,w_es)
    
    ls_pred_new_linear.append(y_pred)
    ls_mse_linear.append((1200*np.log(data[(i+454),116]/data[(i+453),116])-y_pred)**2)
    
    
#---------------------------------------------------------------------------------    
#plot: inflation rate and its estimator(from 2002-Fre to 2011-Nov)
fig = plt.figure(figsize =(12, 7))
a = list(range(118))
d = month = pd.date_range('2002-02','2011-11', 
              freq='MS').strftime("%Y-%b").tolist()

fig, ax = plt.subplots(tight_layout=True)

ax.set_xlabel('date')
ax.set_ylabel('Inflation rate')
# draw one line
ln1 = ax.plot(range(118),np.array(ls_rep), label="true value")
ln2 = ax.plot(range(118), np.array(ls_pred_new_linear),label = "linear")
ln3 = ax.plot(range(118), np.array(ls_pred_new_neural1),label = "neural(3 layers)")
ax.legend(loc='best')
# helper function for the formatter
def listifed_formatter(x, pos=None):
    try:
        return d[int(x)]
    except IndexError:
        return ''

# make and use the formatter
mt = mticker.FuncFormatter(listifed_formatter)
ax.xaxis.set_major_formatter(mt)
ax.set_ylim([-30,30])
# set the default ticker to only put ticks on the integers
loc = ax.xaxis.get_major_locator()
loc.set_params(integer=True)

#---------------------------------------------------------------------------------
#MSE for three methods
print(sum(ls_mse_linear)/118)
print(sum(ls_mse_neural1)/118)
print(sum(ls_mse_neural2)/118)